/*
 * Decompiled with CFR 0.152.
 */
package com.janetfilter.plugins.native_wrapper;

import com.janetfilter.core.Environment;
import com.janetfilter.core.commons.DebugInfo;
import com.janetfilter.core.models.FilterRule;
import com.janetfilter.core.plugin.MyTransformer;
import java.util.ArrayList;
import java.util.List;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.tree.ClassNode;
import jdk.internal.org.objectweb.asm.tree.InsnList;
import jdk.internal.org.objectweb.asm.tree.InsnNode;
import jdk.internal.org.objectweb.asm.tree.MethodInsnNode;
import jdk.internal.org.objectweb.asm.tree.MethodNode;
import jdk.internal.org.objectweb.asm.tree.VarInsnNode;

public class WrapperTransformer
implements MyTransformer {
    private final Environment env;
    private final List<FilterRule> rules;

    public WrapperTransformer(Environment env, List<FilterRule> rules) {
        this.env = env;
        this.rules = rules;
    }

    public String getHookClassName() {
        return null;
    }

    public byte[] transform(String className, byte[] classBytes, int order) throws Exception {
        if (!this.classMatched(className)) {
            return classBytes;
        }
        ClassReader reader = new ClassReader(classBytes);
        ClassNode node = new ClassNode(327680);
        reader.accept(node, 0);
        String prefix = this.env.getNativePrefix();
        ArrayList<MethodNode> methodNodes = new ArrayList<MethodNode>();
        for (MethodNode mn : node.methods) {
            if (0 == (mn.access & 0x100)) continue;
            String originName = mn.name;
            mn.name = prefix + originName;
            MethodNode nmn = new MethodNode(327680);
            nmn.access = mn.access & 0xFFFFFEFF;
            nmn.name = originName;
            nmn.desc = mn.desc;
            nmn.signature = mn.signature;
            nmn.exceptions = mn.exceptions;
            nmn.parameters = mn.parameters;
            nmn.attrs = mn.attrs;
            nmn.visibleAnnotations = mn.visibleAnnotations;
            nmn.invisibleAnnotations = mn.invisibleAnnotations;
            nmn.visibleTypeAnnotations = mn.visibleTypeAnnotations;
            nmn.invisibleTypeAnnotations = mn.invisibleTypeAnnotations;
            nmn.annotationDefault = mn.annotationDefault;
            nmn.visibleParameterAnnotations = mn.visibleParameterAnnotations;
            nmn.invisibleParameterAnnotations = mn.invisibleParameterAnnotations;
            nmn.instructions.insert(this.generateInsnList(nmn, className, mn.name));
            methodNodes.add(nmn);
        }
        node.methods.addAll(methodNodes);
        ClassWriter writer = new ClassWriter(3);
        node.accept(writer);
        return writer.toByteArray();
    }

    private InsnList generateInsnList(MethodNode mn, String className, String wrappedMethodName) {
        char type;
        boolean isNonStatic;
        InsnList list = new InsnList();
        int slot = 0;
        int index = 1;
        boolean bl = isNonStatic = 0 == (mn.access & 8);
        if (isNonStatic) {
            list.add(new VarInsnNode(25, slot++));
        }
        while (')' != (type = mn.desc.charAt(index))) {
            switch (type) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    list.add(new VarInsnNode(21, slot++));
                    break;
                }
                case 'F': {
                    list.add(new VarInsnNode(23, slot++));
                    break;
                }
                case 'D': {
                    list.add(new VarInsnNode(24, slot));
                    slot += 2;
                    break;
                }
                case 'J': {
                    list.add(new VarInsnNode(22, slot));
                    slot += 2;
                    break;
                }
                case 'L': 
                case '[': {
                    list.add(new VarInsnNode(25, slot++));
                }
            }
            index = this.nextDesc(mn.desc, index);
        }
        list.add(new MethodInsnNode(isNonStatic ? 182 : 184, className, wrappedMethodName, mn.desc, false));
        list.add(new InsnNode(this.getReturnOpcode(mn.desc.charAt(index + 1))));
        return list;
    }

    private int nextDesc(String desc, int index) {
        int ret = index + 1;
        switch (desc.charAt(index)) {
            case 'L': {
                while (desc.charAt(ret) != ';') {
                    ++ret;
                }
                return ret + 1;
            }
            case '[': {
                return this.nextDesc(desc, ret);
            }
        }
        return ret;
    }

    private int getReturnOpcode(char returnDesc) {
        switch (returnDesc) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return 172;
            }
            case 'F': {
                return 174;
            }
            case 'D': {
                return 175;
            }
            case 'J': {
                return 173;
            }
            case 'L': 
            case '[': {
                return 176;
            }
            case 'V': {
                return 177;
            }
        }
        throw new RuntimeException("invalid return type");
    }

    private boolean classMatched(String className) {
        for (FilterRule rule : this.rules) {
            if (!rule.test(className)) continue;
            DebugInfo.output((String)("Native wrapper: " + className + ", rule: " + rule));
            return true;
        }
        return false;
    }
}

